<?php
/* --------------------------------------------------------------
   TextPhrasesServiceProvider.php 2020-04-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language;

use Doctrine\DBAL\Connection;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Gambio\Core\Cache\CacheFactory;
use Gambio\Core\Language\Repositories\TextPhraseReader;

/**
 * Class TextPhrasesServiceProvider
 *
 * @package Gambio\Core\Language
 */
class TextPhrasesServiceProvider extends AbstractServiceProvider
{
    private const DEFAULT_LANGUAGE_ID = 2; // german
    
    
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            TextManager::class,
            TextPhraseRepository::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->add(TextPhraseReader::class)->addArgument(Connection::class);
        $this->application->share(TextPhraseRepository::class,
            function () {
                /** @var CacheFactory $cacheFactory */
                $cacheFactory = $this->application->get(CacheFactory::class);
                
                return new Repositories\TextPhraseRepository($cacheFactory->createCacheFor('text_cache'),
                                                             $this->application->get(TextPhraseReader::class));
            });
        
        $this->application->share(TextManager::class, Services\TextManager::class)
            ->addArgument(TextPhraseRepository::class)
            ->addArgument(self::DEFAULT_LANGUAGE_ID);
    }
}